//Magical African Nights by Mick Hazelgrove

// ==== Standard Includes ====
#include "COLORS.inc"
#include "TEXTURES.inc"
#include "METALS.inc"
#include "SHAPES.inc"
#include "SHAPES2.inc"
#include "AfNitetex.inc"
//-----------------------------------------
camera {
	location <0, 0, -12>
	look_at <0, 0, 0>
}
//------------------Lights---------------------

light_source {
	<200,200,-200>,
	color White
	area_light
	<10,0,0>,<0,10,0>,6,6
	adaptive 1
	jitter
shadowless
}


light_source{
  <5,15,-5>
  color rgb <0.68,0.68,0.92>
  spotlight
  point_at <0, 2, 0>
  radius 5
  tightness 100
  falloff 10
}
// Yellow fill in 
light_source{
  <-5,-2,-5>
  color rgb<0.85,0.7,0.1>
  spotlight
  point_at <0, -3, 0>
  radius 5
  tightness 10
  falloff 15
}

//red left torch
light_source{
  <0,5,-5>
  color rgb<1,0,0>
  spotlight
  point_at <-5, 2, 0>
  radius 20
  tightness 25
  falloff 25
}
//Red right torch
light_source{
  <0,5,-5>
  color rgb<1,0,0>
  spotlight
  point_at <5, -3, 0>
  radius 20
  tightness 25
  falloff 25
}
//yellow right
light_source{           
  <10,10,-5>
  color rgb<1,1,0>
  spotlight
  point_at <0, -3, 0>
  radius 20
  tightness 75
  falloff 25
}
//yellow on right torch
light_source{           
  <5,5,-5>
  color rgb<1,1,0>
  spotlight
  point_at <5, -3, 0>
  radius 20
  tightness 75
  falloff 25
}
light_source { < 0, 0, -20 > Coral}
light_source { < 20, 0, -10 >  Yellow}
light_source { <-20, 0, -10 >  Red}
light_source { <0, -5, -5 >  Red} //middle low 

//--------------------Sky---------------------

sky_sphere {
 pigment {
   granite
    color_map {
      [0.00 color rgb <0.00, 0.00, 0.00>]
      [0.84 color rgb <0.00, 0.00, 0.00>]
      [0.85 color rgb <0.80, 0.80, 0.80>]
      [0.86 color rgb <0.20, 0.20, 0.20>]
      [0.87 color rgb <0.95, 0.95, 0.95>]
      [0.88 color rgb <0.00, 0.00, 0.00>]
      [0.89 color rgb <1.00, 1.00, 1.00>]
      [0.90 color rgb <0.95, 0.95, 0.95>]
      [0.91 color rgb <0.00, 0.00, 0.00>]
      [1.00 color rgb <0.00, 0.00, 0.00>]
    }
    scale 0.03
    }
 }

//-------------------Galactic Dust--------------------

#declare Gal_dust = disc{5,z,200
  pigment
      {bozo pigment_map {
         [0.5 leopard  color_map
            {[ 0 color rgbt <0, 0.25, 0.5, .85> ]
              [ 0.25 color rgbt <0, 0.25, 0.75, .4> ]
              [ 0.45 color rgbt <0, 0.25, 0.5,0.75>]}scale 5 turbulence 3]
      }
   }
hollow
}

object {Gal_dust scale 6 translate <2.5,0,8> }
object {Gal_dust scale 10 translate <0,0,8.1> }

//-------------------Halo mist--------------------

  #declare mist = object{sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <0.25, 0, 0, 1> ]
        [ 0.25 color rgbt <0.25, 0, 0.5, -1> ]
        [ 0.65 color rgbt <0.225, 0, 0.05,-0.5>]
      }
      samples 10
      scale 0.5
    }
    hollow
    scale<50,1,20>
   }
  }

  object{mist rotate y* 180 translate<12,-7,-1>}

//------------------Mist----------------------
#declare mist1 = object { Square_Y scale 25
texture{
  pigment{bozo pigment_map {
         [0.5 mandel 12 color_map
             {[ 0 color rgbt <0.5, 0, 0,1> ]
              [ 0.25 color rgbt <0.25, 0, 0.65, -1> ]
              [ 0.65 color rgbt <0.25, 0, 0.65,-0.5>]
             }
              scale 5
              turbulence 1.5 ]
             }
           scallop_wave
        }
   normal{waves normal_map {
        [ 0.0 wrinkles 1 scale 3]
        [ 0.5 ripples 1 scale 1.5]}
       }
      }
  hollow
}


object {mist1
rotate x*-3.5
scale 25
translate<5,-40,20>
}

//---------------------add stars----------------------

#include "MStar.inc"

object{Star scale 1.75 translate<-10.5,8,9>}
object{Star scale 1.25 translate<8,6.5,9>}
object{Star3 scale 1.25 translate<-9,6.5,9>}
object{Star2 scale 1 translate<-11,5.5,9>}

object{Star scale 0.5 translate<-12,9,9>}
object{Star2 scale 0.65 translate<-10,3,9>}
object{Star3 scale 0.75 translate<11,6,9>}
object{Star2 scale 0.9 translate<9.5,9.5,9>}
object{Star4 scale 0.75 translate<9,3.5,9>}

//------------------A Moon-----------------------

object{sphere {0,1
texture{pigment{
       bozo color_map {
      [0.00 color rgbt <0.6,0.75,0.85,0.75>]
      [0.5 color rgbt <0.86,0.85,0.85,0.5>]
      [0.85 color rgbt <0.75,0.85,0.85,0.75>]
    }
    }
    normal{
     onion
      turbulence 1.5
      normal_map{
        [0.00 agate]
        [0.30 leopard  frequency 5 scale 2]
        [0.60 wrinkles  scale 1.25]
        [1.00 bozo]
      }
    }
  }
  }
 scale <0.65,0.65,0.2>
 translate<11,8,8>
 no_shadow
}

//------------------Planets--------------------

#include "planet.inc"

object{planet_circle scale 1.1 rotate z*-36 translate<0,2.75,5.9> no_shadow }

//--------------------torches---------------------

#include "torch.inc"

object{torch texture{Ebony} rotate z*-2.75 scale 0.15 translate<-5,-3,0> no_shadow }
object{torch texture{Ebony} rotate z*2.75 scale 0.15 translate<5,-3,0> no_shadow }

//-------------------flames----------------------

#declare fire = object{
  sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 0.5

      color_map {
        [ 0.0 color rgbt <1, 0, 0, 0.95> ]
        [ 0.5 color rgbt <1, 1, 0, -0.5> ]
        [ 1.0 color rgbt <0.5, 0, 1,  0.5> ]
      }
      samples 10
      scale 0.5
    }
    hollow
    scale 0.75
  }
  no_shadow
  }

object {fire rotate y*180 rotate z*-3 scale 2.2 scale<0.4,2,0.5>translate<-4.95,-1.00,0> no_shadow}
object {fire scale 2.2 scale<0.4,2,0.5>translate<4.95,-1.00,0> no_shadow}

//-----------------Head-----------------------

#include "head.inc"

object{Nhead scale 0.75 translate<0,1,0>}

//-----------------Snake----------------------

#include "Snake.inc"

object{Snake
scale 0.175
rotate y* -90
translate<0,-1.75,0>
no_shadow
}
//-------------------Snakes tongue-------------
#declare tongue = union{
object{cylinder{<0,2,0>,<0,0.9,0>0.1}rotate z*5 translate<0.15,0,0>}
object{cylinder{<0,1,0>,<0,-0.1,0>0.1}rotate z*-5}
object{cylinder{<0,0,0>,<0,-1.1,0>0.1}rotate z*5}
cone{4*y,0.0,2*y, 0.1 rotate z*30 translate<1,0.1,0>}
cone{4*y,0.0,2*y, 0.1 rotate z*-30 translate<-1,0.1,0>}
scale <1,1,0.1>
}

object{tongue
texture{pigment{NeonPink}finish{specular 1}}
rotate<-130,20,-10>
scale 0.25
translate<0.32,2.525,-3>
no_shadow
}
//-------------------Rainbow-------------------
 rainbow {
    angle 16.5
    width 6.5
    arc_angle 320
    falloff_angle 20
    distance 20
    direction <0.0,2.75,20>
    jitter 0.01
    colour_map {
      [0.00  colour Blue 1]
      [0.15  colour Magenta transmit 0.98]
      [0.30  colour DarkPurple transmit 0.9]
      [0.45  colour MediumSlateBlue transmit 0.875]
      [0.60  colour Cyan transmit 0.875]
      [0.75  colour Blue transmit 0.9]
      [0.90  colour Magenta transmit 0.95]
      [1.00  colour Blue transmit 0.99]
    }
  }
